package com.googlecode.jpattern.orm.query;

/**
 * 
 * @author Francesco Cina
 *
 * 18/giu/2011
 */
public interface IJoin extends INameSolverConsumer, IRenderableSqlObject {
	
	/**
	 * Perform a cross Join. 
	 * CROSS JOIN returns the Cartesian product of rows from tables in the join.
	 * A cross join is the join commonly used when more tables are comma 
	 * separated in a from clause.
	 * The name of the class will be used as alias.
	 * @return
	 */
	IJoin cross(Class<?> joinClass);

	/**
	 * Perform a cross Join.
	 * CROSS JOIN returns the Cartesian product of rows from tables in the join.
	 * A cross join is the join commonly used when more tables are comma 
	 * separated in a from clause.
	 * @return
	 */
	IJoin cross(Class<?> joinClass, String joinClassAlias);
	
	/**
	 * Perform a natural Join. 
	 * The join predicate arises implicitly by comparing all columns in both tables that have the same column-names in the joined tables. The resulting joined table contains only one column for each pair of equally-named columns.
	 * The name of the class will be used as alias.
	 * @return
	 */
	IJoin natural(Class<?> joinClass);

	/**
	 * Perform a natural Join.
	 * The join predicate arises implicitly by comparing all columns in both tables that have the same column-names in the joined tables. The resulting joined table contains only one column for each pair of equally-named columns..
	 * @return
	 */
	IJoin natural(Class<?> joinClass, String joinClassAlias);

	/**
	 * Perform a inner Join.
	 * An inner join can be performed in a normal sql query simply using the key JOIN.
	 * @return
	 */
	IJoin inner(Class<?> joinClass);

	/**
	 * Perform a inner Join.
	 * An inner join can be performed in a normal sql simply using the key JOIN.
	 * @return
	 */
	IJoin inner(Class<?> joinClass, String joinClassAlias);
	
	/**
	 * Perform a inner Join.
	 * An inner join can be performed in a normal sql query simply using the key JOIN.
	 * @return
	 */
	IJoin inner(Class<?> joinClass, String onLeftProperty, String onRigthProperty);

	/**
	 * Perform a inner Join.
	 * An inner join can be performed in a normal sql simply using the key JOIN.
	 * @return
	 */
	IJoin inner(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty);
	
	/**
	 * Perform a natural left outer Join.
	 * The name of the class will be used as alias.
	 * @return
	 */
	IJoin leftOuter(Class<?> joinClass);

	/**
	 * Perform a natural left outer Join.
	 * @return
	 */
	IJoin leftOuter(Class<?> joinClass, String joinClassAlias);
	
	/**
	 * Perform a left outer Join.
	 * @return
	 */
	IJoin leftOuter(Class<?> joinClass, String onLeftProperty, String onRigthProperty);

	/**
	 * Perform left outer Join.
	 * @return
	 */
	IJoin leftOuter(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty);
	
	/**
	 * Perform a natural right outer Join.
	 * The name of the class will be used as alias.
	 * @return
	 */
	IJoin rightOuter(Class<?> joinClass);

	/**
	 * Perform a natural right outer Join.
	 * @return
	 */
	IJoin rightOuter(Class<?> joinClass, String joinClassAlias);
	
	/**
	 * Perform a right outer Join.
	 * @return
	 */
	IJoin rightOuter(Class<?> joinClass, String onLeftProperty, String onRigthProperty);

	/**
	 * Perform right outer Join.
	 * @return
	 */
	IJoin rightOuter(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty);
	
	/**
	 * Perform a natural full outer Join.
	 * The name of the class will be used as alias.
	 * @return
	 */
	IJoin fullOuter(Class<?> joinClass);

	/**
	 * Perform a natural full outer Join.
	 * @return
	 */
	IJoin fullOuter(Class<?> joinClass, String joinClassAlias);
	
	/**
	 * Perform a full outer Join.
	 * @return
	 */
	IJoin fullOuter(Class<?> joinClass, String onLeftProperty, String onRigthProperty);

	/**
	 * Perform full outer Join.
	 * @return
	 */
	IJoin fullOuter(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty);
}
