package com.googlecode.jpattern.orm.query;

import java.util.List;

import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.exception.OrmNotUniqueResultException;

/**
 * 
 * @author Francesco Cina
 *
 * 18/giu/2011
 */
public interface IOrmQuery<T> extends IBaseOrmQuery {

	/**
	 * Execute the query returning the list of objects.
	 * @return
	 */
	List<T> findList() throws OrmException;
	
	/**
	 * Return the count of entities this query should return.
	 * @return
	 */
	long findRowCount() throws OrmException;
    
	/**
	 * Execute the query returning either a single bean or null (if no matching bean is found).
	 * @return
	 * @throws OrmNotUniqueResultException if not exactly one row is returned from the query execution
	 */
	T findUnique() throws OrmNotUniqueResultException;
    
	/**
	 * Return the sql that was generated for to return the row count of the execution of this query.
	 * @return
	 */
	String getGeneratedRowCountSql() throws OrmException;
	
	/**
	 * use Distinct in the select clause
	 * @return
	 */
	IOrmQuery<T> setDistinct() throws OrmException;    
	
	/**
	 * return if use Distinct in the select clause
	 * @return
	 */
	boolean isDistinct() throws OrmException;  

}
