package com.googlecode.jpattern.orm.query;

import java.util.List;

/**
 * 
 * @author Francesco Cina
 *
 * 10/lug/2011
 */
public interface ISetClause extends IRenderableSqlObject, INameSolverConsumer {

	/**
	 * Express the new value of the objects property after the execution of the update.
	 * 
	 * @param property
	 * @param value
	 * @return
	 */
	ISetClause eq(String property, Object value);
	
	/**
	 * Append to the list all the values of the expression's elements
	 * @return
	 */
	public void appendValues(List<Object> values);
}
