package com.googlecode.jpattern.orm.query;

import java.util.List;

/**
 * 
 * @author Francesco Cina
 *
 * 10/lug/2011
 */
public interface IUpdate extends IRenderableSqlObject {

	/**
	 * Create or modify the "SET" clause of the update statement. 
	 * @return
	 */
	ISetClause set();
	
	/**
	 * Create or modify the "WHERE" clause of the statement.
	 * @return
	 */
	IExpression where();
	
	/**
	 * Perform the update and return the number of affected rows.
	 * @return
	 */
	int perform();
	
	/**
	 * Append to the list all the values of the expression's elements
	 * @return
	 */
	void appendValues(List<Object> values);
	
	/**
	 * Set the query timeout for the query.
	 */
	IUpdate setQueryTimeout(int queryTimeout);

	/**
	 * Return the query timeout for the query.
	 */
	int getQueryTimeout();
	
}
