package com.googlecode.jpattern.orm.query;

import com.googlecode.jpattern.orm.exception.OrmException;

/**
 * 
 * @author Francesco Cina
 *
 * 19/giu/2011
 */
public class NullNameSolver implements INameSolver {

	@Override
	public String solvePropertyName(String property) {
		return property;
	}

	@Override
	public void register(Class<?> clazz) {
	}

	@Override
	public void register(Class<?> clazz, String alias) {
	}

	@Override
	public String alias(Class<?> clazz) throws OrmException {
		return "";
	}

	@Override
	public String solvePropertyName(String property, String defaultValue) throws OrmException {
		return defaultValue;
	}

	@Override
	public String solvePropertyNameWithoutAlias(String property) throws OrmException {
		return "";
	}

	@Override
	public void alwaysResolveWithoutAlias(boolean resolveWithoutAlias) {
	}

	@Override
	public boolean getAlwaysResolveWithoutAlias() {
		return false;
	}

}
