package com.googlecode.jpattern.orm.query;

import java.util.ArrayList;
import java.util.List;

import com.googlecode.jpattern.orm.query.order.OrderByType;
import com.googlecode.jpattern.orm.query.order.OrderElement;

/**
 * 
 * @author Francesco Cina
 *
 * 24/giu/2011
 */
public class OrderBy implements IOrderBy {

	private INameSolver nameSolver = new NullNameSolver();
	private List<IOrderElement> elementList = new ArrayList<IOrderElement>();

	@Override
	public IOrderBy asc(String property) {
		elementList.add(new OrderElement(nameSolver, property, elementList.isEmpty(), OrderByType.ASC));
		return this;
	}

	@Override
	public IOrderBy desc(String property) {
		elementList.add(new OrderElement(nameSolver, property, elementList.isEmpty(), OrderByType.DESC));
		return this;
	}

	@Override
	public String renderSql() {
		StringBuffer query = new StringBuffer();
		renderSql(query);
		return query.toString();
	}

	@Override
	public void renderSql(StringBuffer stringBuffer) {
		if (!elementList.isEmpty()) {
			stringBuffer.append("ORDER BY ");
			for (IOrderElement expressionElement : elementList) {
				expressionElement.renderSql(stringBuffer);
			}
		}
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver  = nameSolver;
	}

}
