package com.googlecode.jpattern.orm.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.googlecode.jpattern.orm.IOrmClassToolMap;
import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.exception.OrmNotUniqueResultException;
import com.googlecode.jpattern.orm.session.IResultSetReader;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import com.googlecode.jpattern.orm.session.ISqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 20/giu/2011
 */
public class OrmCustomQuery extends ABaseOrmQuery implements IOrmCustomQuery, INameSolverConsumer {

	private INameSolver nameSolver = new NullNameSolver();
	private final ISelectClause select;
	private final IOrmClassToolMap ormClassToolMap;
	private final Class<?> clazz;
	private final Class<?>[] joinClasses;
	private final ISessionSqlPerformer session;

	public OrmCustomQuery(String selectClause, IOrmClassToolMap ormClassToolMap, ISessionSqlPerformer session, Class<?> clazz, Class<?>... joinClasses) {
		this.ormClassToolMap = ormClassToolMap;
		this.session = session;
		this.clazz = clazz;
		this.joinClasses = joinClasses;
		setJoin( new Join(ormClassToolMap) );
		this.select = new SelectClause(selectClause);
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
		this.where().setNameSolver(nameSolver);
		this.orderBy().setNameSolver(nameSolver);
		this.join().setNameSolver(nameSolver);
		this.select.setNameSolver(nameSolver);
	}

	@Override
	public List<Object[]> findList() {
		List<Object> values = new ArrayList<Object>();
		where().appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForList(renderSql(), values.toArray());
	}


	@Override
	public Object[] findUnique() throws OrmNotUniqueResultException {
		List<Object> values = new ArrayList<Object>();
		where().appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForArray(renderSql(), values.toArray());
	}

	@Override
	protected void renderSelect(StringBuffer stringBuffer) {
		select.renderSql(stringBuffer);
	}

	@Override
	protected void renderFrom(StringBuffer stringBuffer) {
		String alias = nameSolver.alias(clazz);
		stringBuffer.append("FROM ");
		stringBuffer.append(ormClassToolMap.getOrmClassTool(clazz).getClassMapper().getTableMap().getTableNameWithSchema() );
		stringBuffer.append( " " );
		stringBuffer.append(alias);
		stringBuffer.append(" ");
		join().renderSql(stringBuffer);
		if (joinClasses!=null && joinClasses.length>0) {
			for (Class<?> joinClass : joinClasses) {
				stringBuffer.append( ", " );
				stringBuffer.append(ormClassToolMap.getOrmClassTool(joinClass).getClassMapper().getTableMap().getTableNameWithSchema() );
				stringBuffer.append( " " );
				stringBuffer.append(nameSolver.alias(joinClass));
			}
			stringBuffer.append(" ");
		}
	}
	
	@Override
	protected void renderWhere(StringBuffer stringBuffer) {
		where().renderSql(stringBuffer);
	}
	
	@Override
	protected void renderOrderBy(StringBuffer stringBuffer) {
		orderBy().renderSql(stringBuffer);
	}

	@Override
	public <T> T find(IResultSetReader<T> rse) throws OrmException {
		List<Object> values = new ArrayList<Object>();
		where().appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.query(renderSql(), rse, values.toArray());
	}

	@Override
	public int findInt() throws OrmException {
		List<Object> values = new ArrayList<Object>();
		where().appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForInt(renderSql(), values.toArray());
	}

	@Override
	public long findLong() throws OrmException {
		List<Object> values = new ArrayList<Object>();
		where().appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForLong(renderSql(), values.toArray());
	}

	@Override
	public double findDouble() throws OrmException {
		List<Object> values = new ArrayList<Object>();
		where().appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForDouble(renderSql(), values.toArray());
	}

	@Override
	public float findFloat() throws OrmException {
		List<Object> values = new ArrayList<Object>();
		where().appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForFloat(renderSql(), values.toArray());
	}

	@Override
	public String findString() throws OrmException {
		List<Object> values = new ArrayList<Object>();
		where().appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForString(renderSql(), values.toArray());
	}

	@Override
	public boolean findBoolean() throws OrmException {
		List<Object> values = new ArrayList<Object>();
		where().appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForBoolean(renderSql(), values.toArray());
	}

	@Override
	public BigDecimal findBigDecimal() throws OrmException {
		List<Object> values = new ArrayList<Object>();
		where().appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForBigDecimal(renderSql(), values.toArray());
	}

}
