package com.googlecode.jpattern.orm.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.googlecode.jpattern.orm.query.select.ISelectRegexPattern;

/**
 * 
 * @author Francesco Cina
 *
 * 07/lug/2011
 */
public class SelectClause implements ISelectClause {

//	private static Pattern patternSelectClause = Pattern.compile(ISelectRegexPattern.SQL_SELECT_SPLIT_PATTERN);
	private static Pattern patternProperty = Pattern.compile(ISelectRegexPattern.SQL_SELECT_PROPERTY_PATTERN);
	private final String selectClause;
	private INameSolver nameSolver = new NullNameSolver();

	public SelectClause(String selectClause) {
		this.selectClause = selectClause;
	}

	@Override
	public String renderSql() {
		StringBuffer query = new StringBuffer();
		renderSql(query);
		return query.toString();
	}

	@Override
	public void renderSql(StringBuffer stringBuffer) {
//		List<String> tokens = splitSelect(selectClause);
//		if (tokens.size()>0) {
//			stringBuffer.append("SELECT ");
//			for ( int i=0; i<tokens.size()-1; i++ ) {
//				solveProperties( stringBuffer, tokens.get(i)) ;
//				stringBuffer.append(",");
//			}
//			solveProperties( stringBuffer, tokens.get(tokens.size()-1));
//			stringBuffer.append(" ");
//		}
		stringBuffer.append("SELECT ");
		solveProperties( stringBuffer, selectClause) ;
		stringBuffer.append(" ");
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}
	
	private void solveProperties(StringBuffer stringBuffer, String token) {
        Matcher m = patternProperty.matcher(token);
        int beginIndex = 0;

        while (m.find()) {
		      stringBuffer.append( token.substring(beginIndex, m.start()) );
		      stringBuffer.append( nameSolver.solvePropertyName( m.group() , m.group()) );
		      beginIndex = m.end();
		}
		
        stringBuffer.append( token.substring(beginIndex, token.length()) );
	}

//	private List<String> splitSelect(String select) {
//
//        List<String> result = new ArrayList<String>();
//        Matcher m = patternSelectClause.matcher(select);
//	    while (m.find()) {
//	    	result.add(m.group());
//		}
//	    return result;
//	}
}
