package com.googlecode.jpattern.orm.query.expression;

import java.util.List;

import com.googlecode.jpattern.orm.exception.OrmQueryFormatException;
import com.googlecode.jpattern.orm.query.IExpressionElement;
import com.googlecode.jpattern.orm.query.INameSolver;
import com.googlecode.jpattern.orm.query.NullNameSolver;

/**
 * 
 * @author Francesco Cina
 *
 * 19/giu/2011
 */
public abstract class APropertiesExpressionElement implements IExpressionElement {

	private final String firstProperty;
	private final String secondProperty;
	private INameSolver nameSolver = new NullNameSolver();
	
	public APropertiesExpressionElement(String firstProperty, String secondProperty) {
		this.firstProperty = firstProperty;
		this.secondProperty = secondProperty;		
	}
	
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	private IPropertyDecorator propertyDecorator = new NullPropertyDecorator();
	private IPropertyDecorator valueDecorator = new NullPropertyDecorator();
	
	protected INameSolver nameSolver() {
		return nameSolver;
	}

	protected IPropertyDecorator getPropertyDecorator() {
		return propertyDecorator;
	}

	protected void setPropertyDecorator(IPropertyDecorator propertyDecorator) {
		this.propertyDecorator = propertyDecorator;
	}

	protected IPropertyDecorator getValueDecorator() {
		return valueDecorator;
	}

	protected void setValueDecorator(IPropertyDecorator valueDecorator) {
		this.valueDecorator = valueDecorator;
	}
	
	@Override
	public void renderSql(StringBuffer query) throws OrmQueryFormatException {
		query.append( getPropertyDecorator().decore( nameSolver().solvePropertyName(firstProperty) ) );
		query.append( " " );
		query.append( getExpressionElementKey() );
		query.append( " " );
		query.append( getPropertyDecorator().decore( nameSolver().solvePropertyName(secondProperty) ) );
		query.append( " " );
	}

	@Override
	public String renderSql() throws OrmQueryFormatException {
		StringBuffer query = new StringBuffer();
		renderSql(query);
		return query.toString();		
	}

	public abstract String getExpressionElementKey();
	
	
	public void appendValues(List<Object> values) {
	}

}
