package com.googlecode.jpattern.orm.query.expression;

import java.util.List;

import com.googlecode.jpattern.orm.query.IExpressionElement;
import com.googlecode.jpattern.orm.query.INameSolver;

/**
 * 
 * @author Francesco Cina
 *
 * 26/giu/2011
 */
public abstract class BinaryExpressionElement implements IExpressionElement{


	private final String relationType;
	protected final IExpressionElement expressionOne;
	protected final IExpressionElement expressionTwo;

	public BinaryExpressionElement(IExpressionElement expressionOne, IExpressionElement expressionTwo, String relationType) {
		this.expressionOne = expressionOne;
		this.expressionTwo = expressionTwo;
		this.relationType = relationType;
	}

	@Override
	public String renderSql() {
		StringBuffer stringBuffer = new StringBuffer();
		renderSql(stringBuffer);
		return stringBuffer.toString();
	}

	@Override
	public void renderSql(StringBuffer stringBuffer) {
		stringBuffer.append("( ");
		expressionOne.renderSql(stringBuffer);
		stringBuffer.append(relationType);
		expressionTwo.renderSql(stringBuffer);
		stringBuffer.append(") ");
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		expressionOne.setNameSolver(nameSolver);
		expressionTwo.setNameSolver(nameSolver);
	}

	@Override
	public void appendValues(List<Object> values) {
		expressionOne.appendValues(values);
		expressionTwo.appendValues(values);
	}

}