package com.googlecode.jpattern.orm.query.expression;

import java.util.List;

import com.googlecode.jpattern.orm.query.IExpressionElement;
import com.googlecode.jpattern.orm.query.INameSolver;
import com.googlecode.jpattern.orm.query.IQuery;

/**
 * 
 * @author Francesco Cina
 *
 * 26/giu/2011
 */
public class InSubQueryExpressionElement implements IExpressionElement {

	private final IQuery query;
	private INameSolver nameSolver;
	private final String property;
	private final boolean in;

	public InSubQueryExpressionElement(String property, IQuery query, boolean in) {
		this.property = property;
		this.query = query;
		this.in = in;
	}

	@Override
	public String renderSql() {
		StringBuffer stringBuffer = new StringBuffer();
		renderSql(stringBuffer);
		return stringBuffer.toString();
	}

	@Override
	public void renderSql(StringBuffer stringBuffer) {
		stringBuffer.append(  nameSolver.solvePropertyName( property ) );
		if (in) {
			stringBuffer.append( " IN ( ");
		} else {
			stringBuffer.append( " NOT IN ( ");
		}
		query.renderSql(stringBuffer);
		stringBuffer.append(") ");
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public void appendValues(List<Object> values) {
		query.appendValues(values);
	}

}