package com.googlecode.jpattern.orm.query.expression;

import java.util.List;

import com.googlecode.jpattern.orm.query.IExpressionElement;
import com.googlecode.jpattern.orm.query.INameSolver;

/**
 * 
 * @author Francesco Cina
 *
 * 26/giu/2011
 */
public class NotExpressionElement implements IExpressionElement {

	
	
	protected final IExpressionElement expression;

	public NotExpressionElement(IExpressionElement expression) {
		this.expression = expression;
	}

	@Override
	public String renderSql() {
		StringBuffer stringBuffer = new StringBuffer();
		renderSql(stringBuffer);
		return stringBuffer.toString();
	}

	@Override
	public void renderSql(StringBuffer stringBuffer) {
		stringBuffer.append("NOT ( ");
		expression.renderSql(stringBuffer);
		stringBuffer.append(") ");
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		expression.setNameSolver(nameSolver);
	}

	@Override
	public void appendValues(List<Object> values) {
		expression.appendValues(values);
	}

}