package com.googlecode.jpattern.orm.query.join;

import com.googlecode.jpattern.orm.IOrmClassToolMap;
import com.googlecode.jpattern.orm.query.INameSolver;

/**
 * 
 * @author Francesco Cina
 *
 * 27/giu/2011
 */
public abstract class AJoinElement implements IJoinElement {

	protected final Class<?> joinClass;
	private INameSolver nameSolver;
	protected final IOrmClassToolMap ormClassToolMap;

	public AJoinElement(IOrmClassToolMap ormClassToolMap, Class<?> joinClass) {
		this.ormClassToolMap = ormClassToolMap;
		this.joinClass = joinClass;
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public String renderSql() {
		StringBuffer query = new StringBuffer();
		renderSql(query);
		return query.toString();
	}

	@Override
	public void renderSql(StringBuffer stringBuffer) {
		String alias = nameSolver.alias(joinClass); 
		stringBuffer.append( getJoinName() );
		stringBuffer.append(ormClassToolMap.getOrmClassTool(joinClass).getClassMapper().getTableMap().getTableNameWithSchema() );
		stringBuffer.append( " " );
		stringBuffer.append(alias);
		
		if (hasOnClause()) {
			stringBuffer.append( " ON " );
			stringBuffer.append( nameSolver.solvePropertyName(onLeftProperty()) );
			stringBuffer.append( " = " );
			stringBuffer.append( nameSolver.solvePropertyName(onRightProperty()) );
		}
		
		stringBuffer.append( " " );
	}
	
	protected abstract String getJoinName();
	
	protected abstract boolean hasOnClause();
	
	protected abstract String onLeftProperty();
	
	protected abstract String onRightProperty();

}