package com.googlecode.jpattern.orm.query.join;

import com.googlecode.jpattern.orm.IOrmClassToolMap;

/**
 * 
 * @author Francesco Cina
 *
 * 27/giu/2011
 */
public class LeftOuterJoinElement extends AJoinElement {

	private final String onLeftProperty;
	private final String onRigthProperty;
	private boolean onClause = true;

	public LeftOuterJoinElement(IOrmClassToolMap ormClassToolMap, Class<?> joinClass) {
		this(ormClassToolMap, joinClass, "", "");
		onClause = false;
	}
	
	public LeftOuterJoinElement(IOrmClassToolMap ormClassToolMap, Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
		super(ormClassToolMap, joinClass);
		this.onLeftProperty = onLeftProperty;
		this.onRigthProperty = onRigthProperty;
	}

	@Override
	protected String getJoinName() {
		return "LEFT OUTER JOIN ";
	}

	@Override
	protected boolean hasOnClause() {
		return onClause ;
	}

	@Override
	protected String onLeftProperty() {
		return onLeftProperty;
	}

	@Override
	protected String onRightProperty() {
		return onRigthProperty;
	}
	
}
