package com.googlecode.jpattern.orm.query.order;

import com.googlecode.jpattern.orm.query.INameSolver;
import com.googlecode.jpattern.orm.query.IOrderElement;

/**
 * 
 * @author Francesco Cina
 *
 * 24/giu/2011
 */
public class OrderElement implements IOrderElement {

	private final INameSolver nameSolver;
	private final boolean isFirstElement;
	private final OrderByType type;
	private final String property;

	public OrderElement(INameSolver nameSolver, String property, boolean isFirstElement, OrderByType type) {
		this.nameSolver = nameSolver;
		this.property = property;
		this.isFirstElement = isFirstElement;
		this.type = type;
	}
	
	@Override
	public String renderSql() {
		StringBuffer query = new StringBuffer();
		renderSql(query);
		return query.toString();
	}

	@Override
	public void renderSql(StringBuffer stringBuffer) {
		if (!isFirstElement) {
			stringBuffer.append( ", " );
		}
		stringBuffer.append( nameSolver.solvePropertyName(property) );
		stringBuffer.append( " " );
		stringBuffer.append( type.getType() );
		stringBuffer.append( " " );
	}

}
