package com.googlecode.jpattern.orm.query.sql;

import java.util.List;

import com.googlecode.jpattern.orm.query.ISqlBatchUpdate;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import com.googlecode.jpattern.orm.session.ISqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class SqlBatchUpdate implements ISqlBatchUpdate {

	private int queryTimeout = 0;
	private final ISessionSqlPerformer session;
	private final String sql;
	private final List<Object[]> args;

	public SqlBatchUpdate(ISessionSqlPerformer session, String sql, List<Object[]> args) {
		this.session = session;
		this.sql = sql;
		this.args = args;
	}

	@Override
	public void execute() {
		update();
	}

	@Override
	public void setQueryTimeout(int queryTimeout) {
		this.queryTimeout  = queryTimeout;
	}

	@Override
	public int getQueryTimeout() {
		return queryTimeout;
	}

	@Override
	public int[] update() {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.batchUpdate(sql , args);
	}

}
