package com.googlecode.jpattern.orm.query.sql;

import java.util.List;

import com.googlecode.jpattern.orm.query.ISqlBatchUpdate;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import com.googlecode.jpattern.orm.session.ISqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class SqlListBatchUpdate implements ISqlBatchUpdate {

	private int queryTimeout = 0;
	private final ISessionSqlPerformer session;
	private final List<String> sqls;

	public SqlListBatchUpdate(ISessionSqlPerformer session, List<String> sqls) {
		this.session = session;
		this.sqls = sqls;
	}

	@Override
	public void execute() {
		update();
	}

	@Override
	public void setQueryTimeout(int queryTimeout) {
		this.queryTimeout = queryTimeout;
	}

	@Override
	public int getQueryTimeout() {
		return queryTimeout ;
	}

	@Override
	public int[] update() {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.batchUpdate(sqls);
	}

}
