package com.googlecode.jpattern.orm.query.sql;

import java.math.BigDecimal;
import java.util.List;

import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.exception.OrmNotUniqueResultException;
import com.googlecode.jpattern.orm.query.AQuery;
import com.googlecode.jpattern.orm.query.ISqlQuery;
import com.googlecode.jpattern.orm.session.IResultSetReader;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import com.googlecode.jpattern.orm.session.ISqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class SqlQuery extends AQuery implements ISqlQuery {

	private final ISessionSqlPerformer session;
	private final String sql;
	private final Object[] args;

	public SqlQuery(ISessionSqlPerformer session, String sql, Object[] args) {
		this.session = session;
		this.sql = sql;
		this.args = args;
	}

	@Override
	public <T> T find(IResultSetReader<T> rse) throws OrmException {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.query(renderSql(), rse , args);
	}

	@Override
	public List<Object[]> findList() throws OrmException {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForList(renderSql(), args);
	}

	@Override
	public Object[] findUnique() throws OrmNotUniqueResultException {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForArray(renderSql(), args);
	}

	@Override
	public int findInt() throws OrmException {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForInt(renderSql(), args);
	}

	@Override
	public long findLong() throws OrmException {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForLong(renderSql(), args);
	}

	@Override
	public double findDouble() throws OrmException {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForDouble(renderSql(), args);
	}

	@Override
	public float findFloat() throws OrmException {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForFloat(renderSql(), args);
	}

	@Override
	public String findString() throws OrmException {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForString(renderSql(), args);
	}

	@Override
	public boolean findBoolean() throws OrmException {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForBoolean(renderSql(), args);
	}

	@Override
	public BigDecimal findBigDecimal() throws OrmException {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setMaxRows(getMaxRows());
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.queryForBigDecimal(renderSql(), args);
	}

	@Override
	public void appendValues(List<Object> values) {
		for (Object object: args) {
			values.add(object);
		}
	}

	@Override
	public String renderSql() {
		return sql;
	}

	@Override
	public void renderSql(StringBuffer stringBuffer) {
		stringBuffer.append(sql);
	}

}
