package com.googlecode.jpattern.orm.script;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

import com.googlecode.jpattern.logger.ILogger;
import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.logger.OrmLogger;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 02/lug/2011
 */
public class ScriptExecutor implements IScriptExecutor {

	private final ISessionSqlPerformer session;
	private final ILogger logger;

	public ScriptExecutor(ISessionSqlPerformer session) {
		this.session = session;
		logger = OrmLogger.getOrmLogger(getClass());
	}
	
	@Override
	public void execute(String script) throws OrmException {
		execute(script, Integer.MAX_VALUE);
	}

	@Override
	public void execute(String script, int commitEveryStatements) throws OrmException {
		Charset charset = Charset.defaultCharset();
		InputStream is = new ByteArrayInputStream(script.getBytes(charset));
		try {
			execute(is, charset, commitEveryStatements);
		} catch (IOException e) {
			throw new OrmException(e);
		}
	}

	@Override
	public void execute(InputStream scriptStream) throws IOException, OrmException {
		execute(scriptStream, Charset.defaultCharset());
	}

	@Override
	public void execute(InputStream scriptStream, int commitEveryStatements) throws IOException, OrmException {
		execute(scriptStream, Charset.defaultCharset(), commitEveryStatements);
	}

	@Override
	public void execute(InputStream scriptStream, Charset charset) throws IOException, OrmException {
		execute(scriptStream, charset, Integer.MAX_VALUE);
	}

	@Override
	public void execute(InputStream scriptStream, Charset charset, int commitEveryStatements) throws IOException, OrmException {
		logger.info("execute", "Begin script execution");
		IParser parser = new StreamParser(scriptStream, true, charset);
		SessionParserCallback spc = new SessionParserCallback(session, commitEveryStatements);
		parser.parse(spc);
		spc.commit();
		logger.debug("execute", "End script execution");
	}

}
