package com.googlecode.jpattern.orm.session.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;

import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.session.ITransaction;

/**
 * 
 * @author Francesco Cina
 *
 * 18/giu/2011
 */
public class DataSourceTransaction implements ITransaction {

	private final Connection conn;
	private boolean rollbackOnly = false;
	private Savepoint savepoint;

	public DataSourceTransaction(Connection conn) throws OrmException {
		this.conn = conn;
		try {
			savepoint = this.conn.setSavepoint();
		} catch (SQLException e) {
			throw new OrmException(e);
		}
	}

	@Override
	public void setRollbackOnly() throws OrmException {
		this.rollbackOnly = true;
	}

	@Override
	public void rollback() throws OrmException {
		try {
			conn.rollback(savepoint);
		} catch (SQLException e) {
			throw new OrmException(e);
		} 
	}

	@Override
	public void commit() throws OrmException {
		if (rollbackOnly) {
			rollback();
			return;
		}
		try {
			conn.commit();
		} catch (SQLException e) {
			throw new OrmException(e);
		} 
	}

}
