package com.googlecode.jpattern.orm.session.jdbctemplate;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;

import com.googlecode.jpattern.orm.session.IResultSetReader;

/**
 * 
 * @author Francesco Cina
 *
 * 02/lug/2011
 */
public class ResultSetReaderWrapper<T> implements ResultSetExtractor<T> {

	private final IResultSetReader<T> rse;

	public ResultSetReaderWrapper(IResultSetReader<T> rse) {
		this.rse = rse;
	}

	@Override
	public T extractData(ResultSet rs) throws SQLException, DataAccessException {
		return rse.read(rs);
	}

}
