/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.generator;

import com.googlecode.jpattern.org.cojen.classfile.ClassFile;
import com.googlecode.jpattern.org.cojen.classfile.CodeBuilder;
import com.googlecode.jpattern.org.cojen.classfile.Label;
import com.googlecode.jpattern.org.cojen.classfile.LocalVariable;
import com.googlecode.jpattern.org.cojen.classfile.Location;
import com.googlecode.jpattern.org.cojen.classfile.MethodInfo;
import com.googlecode.jpattern.org.cojen.classfile.Modifiers;
import com.googlecode.jpattern.org.cojen.classfile.TypeDesc;
import com.googlecode.jpattern.orm.IOrmPersistor;
import com.googlecode.jpattern.orm.exception.OrmConfigurationException;
import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.generator.GetterDumpFactory;
import com.googlecode.jpattern.orm.generator.SetterDumpFactory;
import com.googlecode.jpattern.orm.mapper.IClassMapper;
import java.sql.ResultSet;

public class CojenPersistorDump<T> {
    private static final String MAP_ROW_METHOD_NAME = "mapRow";
    private static final String PRIMARY_KEY_VALUES_METHOD_NAME = "primaryKeyValues";
    private static final String NOT_PRIMARY_KEY_VALUES_METHOD_NAME = "notPrimaryKeyValues";
    private static final String ALL_VALUES_METHOD_NAME = "allValues";
    private static final String ALL_NOT_GENERATED_VALUES_METHOD_NAME = "allNotGeneratedValues";
    private static final String UPDATE_PRIMARY_KEY_METHOD_NAME = "updatePrimaryKey";
    private final String className;
    private final IClassMapper<T> classMapper;

    public CojenPersistorDump(String className, IClassMapper<T> classMapper) {
        this.className = className;
        this.classMapper = classMapper;
    }

    public ClassFile createClassFile() throws SecurityException, NoSuchMethodException, OrmConfigurationException {
        ClassFile cf = new ClassFile(this.className, Object.class.getName());
        cf.setTarget("1.6");
        cf.addInterface(IOrmPersistor.class.getName());
        this.createConstructor_1(cf);
        this.createMethod_1(cf);
        this.createMethod_2(cf);
        this.createMethod_3(cf);
        this.createMethod_4(cf);
        this.createMethod_5(cf);
        this.createMethod_6(cf);
        this.createMethod_7(cf);
        this.createMethod_8(cf);
        this.createMethod_9(cf);
        this.createMethod_10(cf);
        this.createMethod_11(cf);
        this.createMethod_12(cf);
        return cf;
    }

    private void createConstructor_1(ClassFile cf) {
        MethodInfo mi = cf.addConstructor(Modifiers.PUBLIC, null);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.invokeSuperConstructor(null);
        b.returnVoid();
    }

    private void createMethod_1(ClassFile cf) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
        String[] allColumnNames;
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, MAP_ROW_METHOD_NAME, TypeDesc.forClass((String)this.classMapper.getMappedClass().getName()), new TypeDesc[]{TypeDesc.STRING, TypeDesc.forClass((String)ResultSet.class.getName()), TypeDesc.INT});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        LocalVariable var_2 = b.getParameter(1);
        TypeDesc type_1 = TypeDesc.forClass((String)this.classMapper.getMappedClass().getName());
        b.newObject(type_1);
        b.dup();
        b.invokeConstructor(this.classMapper.getMappedClass().getName(), null);
        LocalVariable var_4 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_4);
        Label label_1 = b.createLabel();
        label_1.setLocation();
        for (String columnName : allColumnNames = this.classMapper.getAllColumnJavaNames()) {
            b.loadLocal(var_4);
            b.loadLocal(var_2);
            new SetterDumpFactory().visit(b, var_1, this.classMapper, columnName);
        }
        Label label_2 = b.createLabel();
        label_2.setLocation();
        Label label_3 = b.createLabel();
        b.branch((Location)label_3);
        b.exceptionHandler((Location)label_1, (Location)label_2, Exception.class.getName());
        LocalVariable var_5 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_5);
        TypeDesc type_2 = TypeDesc.forClass((String)OrmException.class.getName());
        b.newObject(type_2);
        b.dup();
        b.loadLocal(var_5);
        TypeDesc type_3 = TypeDesc.forClass((String)Exception.class.getName());
        TypeDesc[] params_4 = new TypeDesc[]{type_3};
        b.invokeConstructor(OrmException.class.getName(), params_4);
        b.throwObject();
        label_3.setLocation();
        b.loadLocal(var_4);
        b.returnValue(TypeDesc.OBJECT);
    }

    private void createMethod_2(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, ALL_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[]{TypeDesc.forClass((String)this.classMapper.getMappedClass().getName())});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        String[] allColumnNames = this.classMapper.getAllColumnJavaNames();
        b.loadConstant(allColumnNames.length);
        TypeDesc type_1 = TypeDesc.OBJECT.toArrayType();
        b.newObject(type_1);
        int count = 0;
        for (String columnName : allColumnNames) {
            new GetterDumpFactory().visit(b, count++, var_1, this.classMapper, columnName);
        }
        LocalVariable var_2 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_2);
        b.loadLocal(var_2);
        b.returnValue(TypeDesc.OBJECT);
    }

    private void createMethod_3(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, PRIMARY_KEY_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[]{TypeDesc.forClass((String)this.classMapper.getMappedClass().getName())});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        String[] primaryKeyColumnNames = this.classMapper.getPrimaryKeyColumnJavaNames();
        b.loadConstant(primaryKeyColumnNames.length);
        TypeDesc type_1 = TypeDesc.OBJECT.toArrayType();
        b.newObject(type_1);
        int count = 0;
        for (String columnName : primaryKeyColumnNames) {
            new GetterDumpFactory().visit(b, count++, var_1, this.classMapper, columnName);
        }
        LocalVariable var_2 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_2);
        b.loadLocal(var_2);
        b.returnValue(TypeDesc.OBJECT);
    }

    private void createMethod_4(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, NOT_PRIMARY_KEY_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[]{TypeDesc.forClass((String)this.classMapper.getMappedClass().getName())});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        String[] notPrimaryKeyColumnNames = this.classMapper.getNotPrimaryKeyColumnJavaNames();
        b.loadConstant(notPrimaryKeyColumnNames.length);
        TypeDesc type_1 = TypeDesc.OBJECT.toArrayType();
        b.newObject(type_1);
        int count = 0;
        for (String columnName : notPrimaryKeyColumnNames) {
            new GetterDumpFactory().visit(b, count++, var_1, this.classMapper, columnName);
        }
        LocalVariable var_2 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_2);
        b.loadLocal(var_2);
        b.returnValue(TypeDesc.OBJECT);
    }

    private void createMethod_5(ClassFile cf) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, UPDATE_PRIMARY_KEY_METHOD_NAME, null, new TypeDesc[]{TypeDesc.forClass((String)ResultSet.class.getName()), TypeDesc.forClass((String)this.classMapper.getMappedClass().getName())});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        LocalVariable var_2 = b.getParameter(1);
        String[] allColumnNames = this.classMapper.getAllGeneratedColumnJavaNames();
        if (allColumnNames.length > 0) {
            Label label_1 = b.createLabel();
            label_1.setLocation();
            int count = 1;
            for (String columnName : allColumnNames) {
                b.loadLocal(var_2);
                b.loadLocal(var_1);
                new SetterDumpFactory().visit(b, this.classMapper, columnName, count++);
            }
            Label label_2 = b.createLabel();
            label_2.setLocation();
            Label label_3 = b.createLabel();
            b.branch((Location)label_3);
            b.exceptionHandler((Location)label_1, (Location)label_2, Exception.class.getName());
            LocalVariable var_3 = b.createLocalVariable(null, TypeDesc.OBJECT);
            b.storeLocal(var_3);
            TypeDesc type_1 = TypeDesc.forClass((String)OrmException.class.getName());
            b.newObject(type_1);
            b.dup();
            b.loadLocal(var_3);
            TypeDesc type_2 = TypeDesc.forClass((String)Exception.class.getName());
            TypeDesc[] params_3 = new TypeDesc[]{type_2};
            b.invokeConstructor(OrmException.class.getName(), params_3);
            b.throwObject();
            label_3.setLocation();
        }
        b.returnVoid();
    }

    private void createMethod_6(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), NOT_PRIMARY_KEY_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[]{TypeDesc.OBJECT});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        b.loadThis();
        b.loadLocal(var_1);
        TypeDesc type_1 = TypeDesc.forClass((String)this.classMapper.getMappedClass().getName());
        b.checkCast(type_1);
        TypeDesc type_2 = TypeDesc.OBJECT.toArrayType();
        TypeDesc[] params_1 = new TypeDesc[]{type_1};
        b.invokeVirtual(NOT_PRIMARY_KEY_VALUES_METHOD_NAME, type_2, params_1);
        b.returnValue(TypeDesc.OBJECT);
    }

    private void createMethod_7(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), ALL_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[]{TypeDesc.OBJECT});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        b.loadThis();
        b.loadLocal(var_1);
        TypeDesc type_1 = TypeDesc.forClass((String)this.classMapper.getMappedClass().getName());
        b.checkCast(type_1);
        TypeDesc type_2 = TypeDesc.OBJECT.toArrayType();
        TypeDesc[] params_1 = new TypeDesc[]{type_1};
        b.invokeVirtual(ALL_VALUES_METHOD_NAME, type_2, params_1);
        b.returnValue(TypeDesc.OBJECT);
    }

    private void createMethod_8(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), PRIMARY_KEY_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[]{TypeDesc.OBJECT});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        b.loadThis();
        b.loadLocal(var_1);
        TypeDesc type_1 = TypeDesc.forClass((String)this.classMapper.getMappedClass().getName());
        b.checkCast(type_1);
        TypeDesc type_2 = TypeDesc.OBJECT.toArrayType();
        TypeDesc[] params_1 = new TypeDesc[]{type_1};
        b.invokeVirtual(PRIMARY_KEY_VALUES_METHOD_NAME, type_2, params_1);
        b.returnValue(TypeDesc.OBJECT);
    }

    private void createMethod_9(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), MAP_ROW_METHOD_NAME, TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.STRING, TypeDesc.forClass((String)ResultSet.class.getName()), TypeDesc.INT});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        LocalVariable var_2 = b.getParameter(1);
        LocalVariable var_3 = b.getParameter(2);
        b.loadThis();
        b.loadLocal(var_1);
        b.loadLocal(var_2);
        b.loadLocal(var_3);
        TypeDesc type_1 = TypeDesc.forClass((String)this.classMapper.getMappedClass().getName());
        TypeDesc type_2 = TypeDesc.forClass((String)ResultSet.class.getName());
        TypeDesc[] params_1 = new TypeDesc[]{TypeDesc.STRING, type_2, TypeDesc.INT};
        b.invokeVirtual(MAP_ROW_METHOD_NAME, type_1, params_1);
        b.returnValue(TypeDesc.OBJECT);
    }

    private void createMethod_10(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), UPDATE_PRIMARY_KEY_METHOD_NAME, null, new TypeDesc[]{TypeDesc.forClass((String)ResultSet.class.getName()), TypeDesc.OBJECT});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        LocalVariable var_2 = b.getParameter(1);
        b.loadThis();
        b.loadLocal(var_1);
        b.loadLocal(var_2);
        TypeDesc type_1 = TypeDesc.forClass((String)this.classMapper.getMappedClass().getName());
        b.checkCast(type_1);
        TypeDesc type_2 = TypeDesc.forClass((String)ResultSet.class.getName());
        TypeDesc[] params_1 = new TypeDesc[]{type_2, type_1};
        b.invokeVirtual(UPDATE_PRIMARY_KEY_METHOD_NAME, null, params_1);
        b.returnVoid();
    }

    private void createMethod_11(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, ALL_NOT_GENERATED_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[]{TypeDesc.forClass((String)this.classMapper.getMappedClass().getName())});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        String[] allNotGeneratedColumnNames = this.classMapper.getAllNotGeneratedColumnJavaNames();
        b.loadConstant(allNotGeneratedColumnNames.length);
        TypeDesc type_1 = TypeDesc.OBJECT.toArrayType();
        b.newObject(type_1);
        int count = 0;
        for (String columnName : allNotGeneratedColumnNames) {
            new GetterDumpFactory().visit(b, count++, var_1, this.classMapper, columnName);
        }
        LocalVariable var_2 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_2);
        b.loadLocal(var_2);
        b.returnValue(TypeDesc.OBJECT);
    }

    private void createMethod_12(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), ALL_NOT_GENERATED_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[]{TypeDesc.OBJECT});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        b.mapLineNumber(1);
        b.loadThis();
        b.loadLocal(var_1);
        TypeDesc type_1 = TypeDesc.forClass((String)this.classMapper.getMappedClass().getName());
        b.checkCast(type_1);
        TypeDesc type_2 = TypeDesc.OBJECT.toArrayType();
        TypeDesc[] params_1 = new TypeDesc[]{type_1};
        b.invokeVirtual(ALL_NOT_GENERATED_VALUES_METHOD_NAME, type_2, params_1);
        b.returnValue(TypeDesc.OBJECT);
    }
}

