/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.mapper;

import com.googlecode.jpattern.orm.mapper.IClassMapper;
import com.googlecode.jpattern.orm.mapper.IColumn;
import com.googlecode.jpattern.orm.mapper.ITableMap;
import com.googlecode.jpattern.orm.mapper.NullColumn;
import java.util.Map;

public class ClassMapper<T>
implements IClassMapper<T> {
    private final Class<T> mappedClass;
    private final Map<String, IColumn> fieldColumnMapping;
    private String[] allColumnJavaNames = new String[0];
    private String[] allNotGeneratedColumnJavaNames = new String[0];
    private String[] primaryKeyColumnJavaNames = new String[0];
    private String[] notPrimaryKeyColumnJavaNames = new String[0];
    private String[] allGeneratedColumnJavaNames = new String[0];
    private String[] allGeneratedColumnDBNames = new String[0];
    private final ITableMap tableMap;

    public ClassMapper(Class<T> mappedClass, ITableMap tableMap, Map<String, IColumn> fieldColumnMapping) {
        this.mappedClass = mappedClass;
        this.tableMap = tableMap;
        this.fieldColumnMapping = fieldColumnMapping;
    }

    @Override
    public Class<T> getMappedClass() {
        return this.mappedClass;
    }

    @Override
    public IColumn getColumnWithJavaName(String javaName) {
        if (this.fieldColumnMapping.containsKey(javaName)) {
            return this.fieldColumnMapping.get(javaName);
        }
        return new NullColumn();
    }

    @Override
    public String[] getAllColumnJavaNames() {
        return this.allColumnJavaNames;
    }

    @Override
    public String[] getPrimaryKeyColumnJavaNames() {
        return this.primaryKeyColumnJavaNames;
    }

    @Override
    public String[] getNotPrimaryKeyColumnJavaNames() {
        return this.notPrimaryKeyColumnJavaNames;
    }

    public void setAllColumnJavaNames(String[] allColumnJavaNames) {
        this.allColumnJavaNames = allColumnJavaNames;
    }

    public void setPrimaryKeyColumnJavaNames(String[] primaryKeyColumnJavaNames) {
        this.primaryKeyColumnJavaNames = primaryKeyColumnJavaNames;
    }

    public void setNotPrimaryKeyColumnJavaNames(String[] notPrimaryKeyColumnJavaNames) {
        this.notPrimaryKeyColumnJavaNames = notPrimaryKeyColumnJavaNames;
    }

    @Override
    public ITableMap getTableMap() {
        return this.tableMap;
    }

    public void setAllNotGeneratedColumnJavaNames(String[] allNotGeneratedColumnJavaNames) {
        this.allNotGeneratedColumnJavaNames = allNotGeneratedColumnJavaNames;
    }

    @Override
    public String[] getAllNotGeneratedColumnJavaNames() {
        return this.allNotGeneratedColumnJavaNames;
    }

    public void setAllGeneratedColumnJavaNames(String[] allGeneratedColumnJavaNames) {
        this.allGeneratedColumnJavaNames = allGeneratedColumnJavaNames;
    }

    @Override
    public String[] getAllGeneratedColumnJavaNames() {
        return this.allGeneratedColumnJavaNames;
    }

    public void setAllGeneratedColumnDBNames(String[] allGeneratedColumnDBNames) {
        this.allGeneratedColumnDBNames = allGeneratedColumnDBNames;
    }

    @Override
    public String[] getAllGeneratedColumnDBNames() {
        return this.allGeneratedColumnDBNames;
    }
}

