/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.query.join;

import com.googlecode.jpattern.orm.IOrmClassToolMap;
import com.googlecode.jpattern.orm.query.INameSolver;
import com.googlecode.jpattern.orm.query.join.IJoinElement;

public abstract class AJoinElement
implements IJoinElement {
    protected final Class<?> joinClass;
    private INameSolver nameSolver;
    protected final IOrmClassToolMap ormClassToolMap;

    public AJoinElement(IOrmClassToolMap ormClassToolMap, Class<?> joinClass) {
        this.ormClassToolMap = ormClassToolMap;
        this.joinClass = joinClass;
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    @Override
    public String renderSql() {
        StringBuffer query = new StringBuffer();
        this.renderSql(query);
        return query.toString();
    }

    @Override
    public void renderSql(StringBuffer stringBuffer) {
        String alias = this.nameSolver.alias(this.joinClass);
        stringBuffer.append(this.getJoinName());
        stringBuffer.append(this.ormClassToolMap.getOrmClassTool(this.joinClass).getClassMapper().getTableMap().getTableNameWithSchema());
        stringBuffer.append(" ");
        stringBuffer.append(alias);
        if (this.hasOnClause()) {
            stringBuffer.append(" ON ");
            stringBuffer.append(this.nameSolver.solvePropertyName(this.onLeftProperty()));
            stringBuffer.append(" = ");
            stringBuffer.append(this.nameSolver.solvePropertyName(this.onRightProperty()));
        }
        stringBuffer.append(" ");
    }

    protected abstract String getJoinName();

    protected abstract boolean hasOnClause();

    protected abstract String onLeftProperty();

    protected abstract String onRightProperty();
}

