/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.query.sql;

import com.googlecode.jpattern.orm.query.ISqlBatchUpdate;
import com.googlecode.jpattern.orm.session.IPreparedStatementCreator;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import com.googlecode.jpattern.orm.session.ISqlPerformer;

public class SqlUpdatePSCreator
implements ISqlBatchUpdate {
    private int queryTimeout = 0;
    private final ISessionSqlPerformer session;
    private final String sql;
    private final IPreparedStatementCreator psc;

    public SqlUpdatePSCreator(ISessionSqlPerformer session, String sql, IPreparedStatementCreator psc) {
        this.session = session;
        this.sql = sql;
        this.psc = psc;
    }

    @Override
    public void execute() {
        this.update();
    }

    @Override
    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public int[] update() {
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.batchUpdate(this.sql, this.psc);
    }
}

