/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.session;

import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.session.IResultSetReader;
import com.googlecode.jpattern.orm.session.ISqlPerformer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class ASqlPerformer
implements ISqlPerformer {
    @Override
    public final int queryForInt(String sql, Object ... values) {
        IResultSetReader<Integer> resultSetReader = new IResultSetReader<Integer>(){

            @Override
            public Integer read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    return resultSet.getInt(1);
                }
                return 0;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final long queryForLong(String sql, Object ... values) {
        IResultSetReader<Long> resultSetReader = new IResultSetReader<Long>(){

            @Override
            public Long read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    return resultSet.getLong(1);
                }
                return 0L;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final double queryForDouble(String sql, Object ... values) throws OrmException {
        IResultSetReader<Double> resultSetReader = new IResultSetReader<Double>(){

            @Override
            public Double read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    return resultSet.getDouble(1);
                }
                return 0.0;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final float queryForFloat(String sql, Object ... values) throws OrmException {
        IResultSetReader<Float> resultSetReader = new IResultSetReader<Float>(){

            @Override
            public Float read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    return Float.valueOf(resultSet.getFloat(1));
                }
                return Float.valueOf(0.0f);
            }
        };
        return this.query(sql, resultSetReader, values).floatValue();
    }

    @Override
    public final String queryForString(String sql, Object ... values) throws OrmException {
        IResultSetReader<String> resultSetReader = new IResultSetReader<String>(){

            @Override
            public String read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    return resultSet.getString(1);
                }
                return "";
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final boolean queryForBoolean(String sql, Object ... values) throws OrmException {
        IResultSetReader<Boolean> resultSetReader = new IResultSetReader<Boolean>(){

            @Override
            public Boolean read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    return resultSet.getBoolean(1);
                }
                return false;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final BigDecimal queryForBigDecimal(String sql, Object ... values) throws OrmException {
        IResultSetReader<BigDecimal> resultSetReader = new IResultSetReader<BigDecimal>(){

            @Override
            public BigDecimal read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    return resultSet.getBigDecimal(1);
                }
                return new BigDecimal(0);
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final Object[] queryForArray(String sql, Object ... values) throws OrmException {
        IResultSetReader<Object[]> resultSetReader = new IResultSetReader<Object[]>(){

            @Override
            public Object[] read(ResultSet resultSet) throws SQLException {
                int columnNumber = resultSet.getMetaData().getColumnCount();
                Object[] result = new Object[columnNumber];
                if (resultSet.next()) {
                    for (int i = 0; i < columnNumber; ++i) {
                        result[i] = resultSet.getObject(i + 1);
                    }
                }
                return result;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final List<Object[]> queryForList(String sql, Object ... values) throws OrmException {
        IResultSetReader<List<Object[]>> resultSetReader = new IResultSetReader<List<Object[]>>(){

            @Override
            public List<Object[]> read(ResultSet resultSet) throws SQLException {
                int columnNumber = resultSet.getMetaData().getColumnCount();
                ArrayList<Object[]> resultList = new ArrayList<Object[]>();
                while (resultSet.next()) {
                    Object[] objectArray = new Object[columnNumber];
                    for (int i = 0; i < columnNumber; ++i) {
                        objectArray[i] = resultSet.getObject(i + 1);
                    }
                    resultList.add(objectArray);
                }
                return resultList;
            }
        };
        return this.query(sql, resultSetReader, values);
    }
}

