/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.session.jdbctemplate;

import com.googlecode.jpattern.orm.IOrmClassToolMap;
import com.googlecode.jpattern.orm.mapper.DBTableMapBuilder;
import com.googlecode.jpattern.orm.mapper.ITableMap;
import com.googlecode.jpattern.orm.session.ISession;
import com.googlecode.jpattern.orm.session.ISessionProvider;
import com.googlecode.jpattern.orm.session.jdbctemplate.JdbcTemplateSession;
import com.googlecode.jpattern.orm.session.jdbctemplate.NullPlatformTransactionManager;
import java.sql.SQLException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class JdbcTemplateSessionProvider
implements ISessionProvider {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformTransactionManager platformTransactionManager;

    public JdbcTemplateSessionProvider(JdbcTemplate jdbcTemplate) {
        this(jdbcTemplate, new NullPlatformTransactionManager());
    }

    public JdbcTemplateSessionProvider(JdbcTemplate jdbcTemplate, PlatformTransactionManager platformTransactionManager) {
        this.jdbcTemplate = jdbcTemplate;
        this.platformTransactionManager = platformTransactionManager;
    }

    @Override
    public ISession getSession(IOrmClassToolMap ormClassToolMap) {
        return new JdbcTemplateSession(this.jdbcTemplate, this.platformTransactionManager, ormClassToolMap);
    }

    @Override
    public void updateTableMap(ITableMap tableMap, boolean enableDBScan) throws SQLException {
        new DBTableMapBuilder(this.jdbcTemplate.getDataSource().getConnection(), tableMap, enableDBScan).updateTableMap();
    }
}

