/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.mapper;

import com.googlecode.jpattern.orm.annotation.Column;
import com.googlecode.jpattern.orm.annotation.Generator;
import com.googlecode.jpattern.orm.annotation.Id;
import com.googlecode.jpattern.orm.annotation.Schema;
import com.googlecode.jpattern.orm.annotation.Table;
import com.googlecode.jpattern.orm.crud.AColumnValueGenerator;
import com.googlecode.jpattern.orm.crud.ColumnValueGeneratorFactory;
import com.googlecode.jpattern.orm.crud.NullColumnValueGenerator;
import com.googlecode.jpattern.orm.mapper.ITableMapBuilder;
import com.googlecode.jpattern.orm.mapper.TableMap;
import com.googlecode.jpattern.orm.util.FieldDefaultNaming;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ClassTableMapBuilder
implements ITableMapBuilder {
    private final Class<?> clazz;
    private final TableMap tableMap;

    public ClassTableMapBuilder(Class<?> clazz, TableMap tableMap) {
        this.clazz = clazz;
        this.tableMap = tableMap;
    }

    @Override
    public void updateTableMap() {
        this.generateTableName(this.tableMap);
        this.generateSchemaName(this.tableMap);
        this.generateColumnNames(this.tableMap);
    }

    private void generateColumnNames(TableMap tableMap) {
        Field[] fields;
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            AColumnValueGenerator columnValueGenerator = new NullColumnValueGenerator("");
            String columnName = FieldDefaultNaming.getJavanameToDBnameDefaultMapping(field.getName());
            Id id = field.getAnnotation(Id.class);
            Column column = field.getAnnotation(Column.class);
            Generator generator = field.getAnnotation(Generator.class);
            if (id != null) {
                tableMap.addPrimaryKey(field.getName());
            }
            if (column != null) {
                columnName = column.name();
            }
            if (generator != null) {
                columnValueGenerator = ColumnValueGeneratorFactory.generator(generator.generatorType(), generator.name());
                columnValueGenerator.setCacheSize(generator.getCacheSize());
                columnValueGenerator.setGeneratedColumnName(columnName);
            }
            tableMap.addColumnMapping(field.getName(), columnName, columnValueGenerator);
        }
    }

    private void generateTableName(TableMap tableMap) {
        String tableName = FieldDefaultNaming.getJavanameToDBnameDefaultMapping(this.clazz.getSimpleName());
        Table annotation = this.clazz.getAnnotation(Table.class);
        if (annotation != null) {
            tableName = annotation.name();
        }
        tableMap.setTableName(tableName);
    }

    private void generateSchemaName(TableMap tableMap) {
        Schema annotation = this.clazz.getAnnotation(Schema.class);
        if (annotation != null) {
            tableMap.setSchemaName(annotation.name());
        }
    }
}

