/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.mapper;

import com.googlecode.jpattern.logger.ILogger;
import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.logger.OrmLogger;
import com.googlecode.jpattern.orm.mapper.ITableMap;
import com.googlecode.jpattern.orm.mapper.ITableMapBuilder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DBTableMapBuilder
implements ITableMapBuilder {
    private final DataSource dataSource;
    private final ITableMap tableMap;
    private ILogger logger = OrmLogger.getOrmLogger(this.getClass());
    private final boolean enableDBScan;

    public DBTableMapBuilder(DataSource dataSource, ITableMap tableMap, boolean enableDBScan) {
        this.dataSource = dataSource;
        this.tableMap = tableMap;
        this.enableDBScan = enableDBScan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableMap() throws SQLException {
        if (this.enableDBScan) {
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                this.mapField(connection, this.tableMap.getSchemaName(), this.tableMap.getTableName());
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        throw new OrmException(e);
                    }
                }
            }
        }
    }

    private void mapField(Connection connection, String schemaName, String tableName) throws SQLException {
        this.exploreMetaData(connection, schemaName, tableName);
    }

    private void exploreMetaData(Connection connection, String schemaName, String tableName) throws SQLException {
        DatabaseMetaData dbmd = null;
        dbmd = connection.getMetaData();
        String schema = null;
        if (schemaName != null && schemaName.length() > 0) {
            schema = schemaName;
        }
        if (this.tableMap.getPrimaryKeyFieldNames().size() == 0) {
            this.logger.info("getPrimaryKeyColumns", "No annotations used to identify primary keys. Search them in the DB metadata.");
            ResultSet res = dbmd.getPrimaryKeys(null, schema, tableName);
            while (res.next()) {
                this.tableMap.getPrimaryKeyFieldNames().add(this.tableMap.getJavaFieldName(res.getString("COLUMN_NAME")));
            }
            res.close();
        } else {
            this.logger.info("getPrimaryKeyColumns", "Annotations are used to identify primary keys. DB metadata will not be used to retrieve primary keys.");
        }
        this.logger.info("getPrimaryKeyColumns", "following field will be used as primary key for table " + schemaName + "." + tableName + ": " + this.tableMap.getPrimaryKeyFieldNames());
    }
}

