/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.query;

import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.query.ISqlBatchUpdate;
import com.googlecode.jpattern.orm.query.ISqlExecute;
import com.googlecode.jpattern.orm.query.ISqlExecutor;
import com.googlecode.jpattern.orm.query.ISqlQuery;
import com.googlecode.jpattern.orm.query.ISqlUpdate;
import com.googlecode.jpattern.orm.query.sql.SqlBatchUpdate;
import com.googlecode.jpattern.orm.query.sql.SqlExecute;
import com.googlecode.jpattern.orm.query.sql.SqlListBatchUpdate;
import com.googlecode.jpattern.orm.query.sql.SqlQuery;
import com.googlecode.jpattern.orm.query.sql.SqlUpdate;
import com.googlecode.jpattern.orm.query.sql.SqlUpdateGKReader;
import com.googlecode.jpattern.orm.query.sql.SqlUpdatePSCreator;
import com.googlecode.jpattern.orm.session.IGeneratedKeyReader;
import com.googlecode.jpattern.orm.session.IPreparedStatementCreator;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import java.util.List;

public class SqlExecutor
implements ISqlExecutor {
    private final ISessionSqlPerformer session;

    public SqlExecutor(ISessionSqlPerformer session) {
        this.session = session;
    }

    @Override
    public ISqlQuery query(String sql, Object ... args) {
        return new SqlQuery(this.session, sql, args);
    }

    @Override
    public ISqlExecute execute(String sql) throws OrmException {
        return new SqlExecute(this.session, sql);
    }

    @Override
    public ISqlUpdate update(String sql, Object ... args) throws OrmException {
        return new SqlUpdate(this.session, sql, args);
    }

    @Override
    public ISqlUpdate update(String sql, IGeneratedKeyReader generatedKeyReader, Object ... args) throws OrmException {
        return new SqlUpdateGKReader(this.session, sql, generatedKeyReader, args);
    }

    @Override
    public ISqlBatchUpdate batchUpdate(List<String> sqls) throws OrmException {
        return new SqlListBatchUpdate(this.session, sqls);
    }

    @Override
    public ISqlBatchUpdate batchUpdate(String sql, List<Object[]> args) throws OrmException {
        return new SqlBatchUpdate(this.session, sql, args);
    }

    @Override
    public ISqlBatchUpdate batchUpdate(String sql, IPreparedStatementCreator psc) throws OrmException {
        return new SqlUpdatePSCreator(this.session, sql, psc);
    }
}

