/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.query.expression;

import com.googlecode.jpattern.orm.exception.OrmQueryFormatException;
import com.googlecode.jpattern.orm.query.IExpressionElement;
import com.googlecode.jpattern.orm.query.INameSolver;
import com.googlecode.jpattern.orm.query.NullNameSolver;
import com.googlecode.jpattern.orm.query.expression.IPropertyDecorator;
import com.googlecode.jpattern.orm.query.expression.NullPropertyDecorator;
import java.util.Collection;
import java.util.List;

public abstract class AExpressionElement
implements IExpressionElement {
    private String property;
    private Object value;
    private Collection<?> values;
    private INameSolver nameSolver = new NullNameSolver();
    private IPropertyDecorator propertyDecorator = new NullPropertyDecorator();
    private IPropertyDecorator valueDecorator = new NullPropertyDecorator();

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    public final boolean hasValues() {
        return this.values != null && this.values.size() > 0;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Collection<?> getValues() {
        return this.values;
    }

    public void setValues(Collection<?> values) {
        this.values = values;
    }

    public final String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    protected INameSolver nameSolver() {
        return this.nameSolver;
    }

    protected IPropertyDecorator getPropertyDecorator() {
        return this.propertyDecorator;
    }

    protected void setPropertyDecorator(IPropertyDecorator propertyDecorator) {
        this.propertyDecorator = propertyDecorator;
    }

    protected IPropertyDecorator getValueDecorator() {
        return this.valueDecorator;
    }

    protected void setValueDecorator(IPropertyDecorator valueDecorator) {
        this.valueDecorator = valueDecorator;
    }

    @Override
    public void renderSql(StringBuilder query) throws OrmQueryFormatException {
        query.append(this.getPropertyDecorator().decore(this.nameSolver().solvePropertyName(this.getProperty())));
        query.append(" ");
        query.append(this.getExpressionElementKey());
        query.append(" ");
        this.appendQuestionMarks(query);
    }

    private void appendQuestionMarks(StringBuilder query) {
        if (this.hasValue()) {
            query.append(this.getValueDecorator().decore("?") + " ");
            return;
        }
        if (this.hasValues()) {
            query.append("( ");
            for (int i = 0; i < this.getValues().size() - 1; ++i) {
                query.append(this.getValueDecorator().decore("?") + ", ");
            }
            query.append(this.getValueDecorator().decore("?") + " ) ");
        }
    }

    @Override
    public String renderSql() throws OrmQueryFormatException {
        StringBuilder query = new StringBuilder();
        this.renderSql(query);
        return query.toString();
    }

    public abstract String getExpressionElementKey();

    @Override
    public void appendValues(List<Object> values) {
        if (this.hasValue()) {
            values.add(this.value);
        }
        if (this.hasValues()) {
            values.addAll(this.values);
        }
    }
}

