/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.query.expression;

import com.googlecode.jpattern.orm.exception.OrmQueryFormatException;
import com.googlecode.jpattern.orm.query.IExpressionElement;
import com.googlecode.jpattern.orm.query.INameSolver;
import com.googlecode.jpattern.orm.query.NullNameSolver;
import com.googlecode.jpattern.orm.query.expression.IPropertyDecorator;
import com.googlecode.jpattern.orm.query.expression.NullPropertyDecorator;
import java.util.List;

public abstract class APropertiesExpressionElement
implements IExpressionElement {
    private final String firstProperty;
    private final String secondProperty;
    private INameSolver nameSolver = new NullNameSolver();
    private IPropertyDecorator propertyDecorator = new NullPropertyDecorator();
    private IPropertyDecorator valueDecorator = new NullPropertyDecorator();

    public APropertiesExpressionElement(String firstProperty, String secondProperty) {
        this.firstProperty = firstProperty;
        this.secondProperty = secondProperty;
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    protected INameSolver nameSolver() {
        return this.nameSolver;
    }

    protected IPropertyDecorator getPropertyDecorator() {
        return this.propertyDecorator;
    }

    protected void setPropertyDecorator(IPropertyDecorator propertyDecorator) {
        this.propertyDecorator = propertyDecorator;
    }

    protected IPropertyDecorator getValueDecorator() {
        return this.valueDecorator;
    }

    protected void setValueDecorator(IPropertyDecorator valueDecorator) {
        this.valueDecorator = valueDecorator;
    }

    @Override
    public void renderSql(StringBuilder query) throws OrmQueryFormatException {
        query.append(this.getPropertyDecorator().decore(this.nameSolver().solvePropertyName(this.firstProperty)));
        query.append(" ");
        query.append(this.getExpressionElementKey());
        query.append(" ");
        query.append(this.getPropertyDecorator().decore(this.nameSolver().solvePropertyName(this.secondProperty)));
        query.append(" ");
    }

    @Override
    public String renderSql() throws OrmQueryFormatException {
        StringBuilder query = new StringBuilder();
        this.renderSql(query);
        return query.toString();
    }

    public abstract String getExpressionElementKey();

    @Override
    public void appendValues(List<Object> values) {
    }
}

