/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.orm.script;

import com.googlecode.jpattern.logger.ILogger;
import com.googlecode.jpattern.orm.exception.OrmException;
import com.googlecode.jpattern.orm.logger.OrmLogger;
import com.googlecode.jpattern.orm.script.IScriptExecutor;
import com.googlecode.jpattern.orm.script.SessionParserCallback;
import com.googlecode.jpattern.orm.script.StreamParser;
import com.googlecode.jpattern.orm.session.ISessionSqlPerformer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class ScriptExecutor
implements IScriptExecutor {
    private final ISessionSqlPerformer session;
    private final ILogger logger;

    public ScriptExecutor(ISessionSqlPerformer session) {
        this.session = session;
        this.logger = OrmLogger.getOrmLogger(this.getClass());
    }

    @Override
    public void execute(String script) throws OrmException {
        this.execute(script, Integer.MAX_VALUE);
    }

    @Override
    public void execute(String script, int commitEveryStatements) throws OrmException {
        Charset charset = Charset.defaultCharset();
        ByteArrayInputStream is = new ByteArrayInputStream(script.getBytes(charset));
        try {
            this.execute(is, charset, commitEveryStatements);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    @Override
    public void execute(InputStream scriptStream) throws IOException, OrmException {
        this.execute(scriptStream, Charset.defaultCharset());
    }

    @Override
    public void execute(InputStream scriptStream, int commitEveryStatements) throws IOException, OrmException {
        this.execute(scriptStream, Charset.defaultCharset(), commitEveryStatements);
    }

    @Override
    public void execute(InputStream scriptStream, Charset charset) throws IOException, OrmException {
        this.execute(scriptStream, charset, Integer.MAX_VALUE);
    }

    @Override
    public void execute(InputStream scriptStream, Charset charset, int commitEveryStatements) throws IOException, OrmException {
        this.logger.info("execute", "Begin script execution");
        StreamParser parser = new StreamParser(scriptStream, true, charset);
        SessionParserCallback spc = new SessionParserCallback(this.session, commitEveryStatements);
        parser.parse(spc);
        spc.commit();
        this.logger.debug("execute", "End script execution");
    }
}

