/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.rest;

import com.googlecode.jpattern.core.IProvider;
import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.rest.IGetDeleteExecutor;
import com.googlecode.jpattern.rest.IRestManager;
import com.googlecode.jpattern.rest.command.BuildQueryMapCommand;
import com.googlecode.jpattern.rest.command.BuildURLCommand;
import com.googlecode.jpattern.rest.command.ObjectToJsonStreamCommand;
import com.googlecode.jpattern.rest.domain.URLPath;
import com.googlecode.jpattern.shared.result.IResult;
import com.googlecode.jpattern.shared.result.facade.CommandFacadeResult;
import com.googlecode.jpattern.shared.result.facade.ICommandFacadeResult;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetDeleteRestManager
implements IRestManager {
    private static final long serialVersionUID = 1L;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final IGetDeleteExecutor getDeleteExecutor;
    private final String relativePath;
    private final IProvider provider;

    public GetDeleteRestManager(IProvider provider, IGetDeleteExecutor getDeleteExecutor, String relativePath, HttpServletRequest request, HttpServletResponse response) {
        this.provider = provider;
        this.getDeleteExecutor = getDeleteExecutor;
        this.relativePath = relativePath;
        this.request = request;
        this.response = response;
    }

    @Override
    public void execute() {
        try {
            Object result = new ICommandFacadeResult();
            URLPath urlPath = new URLPath();
            HashMap<String, List<String>> resultQueryMap = new HashMap<String, List<String>>();
            ACommand prepareCommand = new BuildURLCommand(this.request, urlPath);
            prepareCommand = new BuildQueryMapCommand(urlPath, resultQueryMap);
            prepareCommand.visit(this.provider);
            ICommandResult prepareCommandResult = prepareCommand.exec();
            result = prepareCommandResult.isValid() ? this.getDeleteExecutor.exec(resultQueryMap, this.relativePath, urlPath) : new CommandFacadeResult((IResult)prepareCommandResult, (Object)"");
            ObjectToJsonStreamCommand postCommand = new ObjectToJsonStreamCommand(result, (OutputStream)this.response.getOutputStream());
            postCommand.visit(this.provider);
            postCommand.exec();
        }
        catch (Exception e) {
            this.provider.getLoggerService().logger(this.getClass()).error("Error generating Rest Answer", e.getMessage(), e);
        }
    }
}

