/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.rest;

import com.googlecode.jpattern.core.IProvider;
import com.googlecode.jpattern.rest.IRestServletResourceMap;
import com.googlecode.jpattern.rest.action.ActionWrapper;
import com.googlecode.jpattern.rest.action.IAction;
import com.googlecode.jpattern.rest.action.IActionWrapper;
import com.googlecode.jpattern.rest.action.IDeleteAction;
import com.googlecode.jpattern.rest.action.IGetAction;
import com.googlecode.jpattern.rest.action.IPostAction;
import com.googlecode.jpattern.rest.action.IPutAction;
import com.googlecode.jpattern.rest.action.NullAction;
import java.util.HashMap;
import java.util.Map;

public class RestServletResourceMap
implements IRestServletResourceMap {
    private static final long serialVersionUID = 1L;
    Map<String, IPostAction> postMap = new HashMap<String, IPostAction>();
    Map<String, IGetAction> getMap = new HashMap<String, IGetAction>();
    Map<String, IPutAction> putMap = new HashMap<String, IPutAction>();
    Map<String, IDeleteAction> deleteMap = new HashMap<String, IDeleteAction>();
    private final IProvider provider;

    public RestServletResourceMap(IProvider provider) {
        this.provider = provider;
    }

    @Override
    public void addAction(String path, IAction action) {
        this.addPut(path, action);
        this.addPost(path, action);
        this.addGet(path, action);
        this.addDelete(path, action);
    }

    @Override
    public IActionWrapper<IGetAction> getAction(String pathInfo) {
        String path = this.getBestKey(pathInfo, this.getMap);
        if (this.getMap.containsKey(path)) {
            return new ActionWrapper<IAction>(this.getMap.get(path), this.getRelativePath(pathInfo, path));
        }
        return new ActionWrapper<IGetAction>(new NullAction(), path);
    }

    @Override
    public IActionWrapper<IDeleteAction> deleteAction(String pathInfo) {
        String path = this.getBestKey(pathInfo, this.deleteMap);
        if (this.deleteMap.containsKey(path)) {
            return new ActionWrapper<IAction>(this.deleteMap.get(path), this.getRelativePath(pathInfo, path));
        }
        return new ActionWrapper<IDeleteAction>(new NullAction(), path);
    }

    @Override
    public IActionWrapper<IPostAction> postAction(String pathInfo) {
        String path = this.getBestKey(pathInfo, this.postMap);
        if (this.postMap.containsKey(path)) {
            return new ActionWrapper<IAction>(this.postMap.get(path), this.getRelativePath(pathInfo, path));
        }
        return new ActionWrapper<IPostAction>(new NullAction(), path);
    }

    @Override
    public IActionWrapper<IPutAction> putAction(String pathInfo) {
        String path = this.getBestKey(pathInfo, this.putMap);
        if (this.putMap.containsKey(path)) {
            return new ActionWrapper<IAction>(this.putMap.get(path), this.getRelativePath(pathInfo, path));
        }
        return new ActionWrapper<IPutAction>(new NullAction(), path);
    }

    private void addPost(String path, IAction action) {
        if (action instanceof IPostAction) {
            this.postMap.put(path, (IPostAction)action);
        }
    }

    private void addPut(String path, IAction action) {
        if (action instanceof IPutAction) {
            this.putMap.put(path, (IPutAction)action);
        }
    }

    private void addGet(String path, IAction action) {
        if (action instanceof IGetAction) {
            this.getMap.put(path, (IGetAction)action);
        }
    }

    private void addDelete(String path, IAction action) {
        if (action instanceof IDeleteAction) {
            this.deleteMap.put(path, (IDeleteAction)action);
        }
    }

    protected String getBestKey(String url, Map<String, ?> map) {
        String temp = url;
        while (!temp.isEmpty()) {
            if (map.containsKey(temp)) {
                return temp;
            }
            int index = temp.lastIndexOf("/");
            if (index >= 0) {
                temp = temp.substring(0, index);
                continue;
            }
            temp = "";
        }
        return temp;
    }

    protected String getRelativePath(String fullpath, String subPath) {
        if (fullpath.length() >= subPath.length()) {
            return fullpath.substring(subPath.length(), fullpath.length());
        }
        return fullpath;
    }

    @Override
    public IProvider provider() {
        return this.provider;
    }
}

