/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.rest.command;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.rest.domain.URLPath;
import com.googlecode.jpattern.shared.result.ErrorMessage;
import com.googlecode.jpattern.shared.result.IErrorMessage;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BuildQueryMapCommand
extends ACommand {
    private static final long serialVersionUID = 1L;
    private final URLPath urlPath;
    private final Map<String, List<String>> resultQueryMap;

    public BuildQueryMapCommand(URLPath urlPath, Map<String, List<String>> resultQueryMap) {
        this(urlPath, resultQueryMap, (ICommand)new NullCommand());
    }

    public BuildQueryMapCommand(URLPath urlPath, Map<String, List<String>> resultQueryMap, ICommand previousCommand) {
        super(previousCommand);
        this.urlPath = urlPath;
        this.resultQueryMap = resultQueryMap;
    }

    protected void result(ICommandResult result) {
        if (this.urlPath.getQueryString().length() > 0) {
            try {
                String query = this.urlPath.getQueryString();
                for (String param : query.split("&")) {
                    String[] pair = param.split("=");
                    String key = URLDecoder.decode(pair[0], "UTF-8");
                    String value = URLDecoder.decode(pair[1], "UTF-8");
                    List<String> values = this.resultQueryMap.get(key);
                    if (values == null) {
                        values = new ArrayList<String>();
                        this.resultQueryMap.put(key, values);
                    }
                    values.add(value);
                    this.resultQueryMap.put(key, values);
                }
            }
            catch (Exception e) {
                result.addErrorMessage((IErrorMessage)new ErrorMessage(((Object)((Object)this)).getClass().getName(), e.getMessage()));
                this.getLogger().error("result", "", e);
            }
        }
    }

    protected void internalRollBack(ICommandResult result) {
    }
}

