/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.rest.command;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.core.util.ValueUtil;
import com.googlecode.jpattern.rest.domain.URLPath;
import javax.servlet.http.HttpServletRequest;

public class BuildURLCommand
extends ACommand {
    private static final long serialVersionUID = 1L;
    private final HttpServletRequest request;
    private final URLPath urlPath;

    public BuildURLCommand(HttpServletRequest request, URLPath urlPath) {
        this(request, urlPath, (ICommand)new NullCommand());
    }

    public BuildURLCommand(HttpServletRequest request, URLPath urlPath, ICommand previousCommand) {
        super(previousCommand);
        this.request = request;
        this.urlPath = urlPath;
    }

    protected void result(ICommandResult result) {
        this.urlPath.setScheme(ValueUtil.stringNotNull((String)this.request.getScheme(), (String)""));
        this.urlPath.setServerName(ValueUtil.stringNotNull((String)this.request.getServerName(), (String)""));
        this.urlPath.setServerPort(this.request.getServerPort());
        this.urlPath.setContextPath(ValueUtil.stringNotNull((String)this.request.getContextPath(), (String)""));
        this.urlPath.setServletPath(ValueUtil.stringNotNull((String)this.request.getServletPath(), (String)""));
        this.urlPath.setPathInfo(ValueUtil.stringNotNull((String)this.request.getPathInfo(), (String)""));
        this.urlPath.setQueryString(ValueUtil.stringNotNull((String)this.request.getQueryString(), (String)""));
    }

    protected void internalRollBack(ICommandResult result) {
    }
}

