/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jpattern.rest.command;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.core.util.GenericWrapper;
import com.googlecode.jpattern.shared.result.ErrorMessage;
import com.googlecode.jpattern.shared.result.IErrorMessage;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonToObjectCommand<T>
extends ACommand {
    private static final long serialVersionUID = 1L;
    private static ObjectMapper MAPPER = new ObjectMapper();
    private final Class<T> aClass;
    private final GenericWrapper<T> resultWrapper;
    private final StringBuffer jsonString;

    public JsonToObjectCommand(Class<T> aClass, GenericWrapper<T> resultWrapper, StringBuffer jsonString) {
        this(aClass, resultWrapper, jsonString, (ICommand)new NullCommand());
    }

    public JsonToObjectCommand(Class<T> aClass, GenericWrapper<T> resultWrapper, StringBuffer jsonString, ICommand previousCommand) {
        super(previousCommand);
        this.aClass = aClass;
        this.resultWrapper = resultWrapper;
        this.jsonString = jsonString;
    }

    protected void result(ICommandResult result) {
        try {
            this.resultWrapper.setValue(MAPPER.readValue(this.jsonString.toString(), this.aClass));
        }
        catch (Exception e) {
            result.addErrorMessage((IErrorMessage)new ErrorMessage(((Object)((Object)this)).getClass().getName(), e.getMessage()));
            this.getLogger().error("result", "", e);
        }
    }

    protected void internalRollBack(ICommandResult result) {
    }
}

