package com.googlecode.jpattern.rest;

import java.io.Serializable;

import com.googlecode.jpattern.core.IProvider;
import com.googlecode.jpattern.rest.action.IAction;
import com.googlecode.jpattern.rest.action.IActionWrapper;
import com.googlecode.jpattern.rest.action.IDeleteAction;
import com.googlecode.jpattern.rest.action.IGetAction;
import com.googlecode.jpattern.rest.action.IPostAction;
import com.googlecode.jpattern.rest.action.IPutAction;

/**
 * 
 * @author Francesco Cina'
 *
 * 11/mag/2011
 */
public interface IRestServletResourceMap extends Serializable {
	
	IProvider provider();
	
	void addAction(String path, IAction action);
	
	IActionWrapper<IGetAction> getAction(String pathInfo);
	
	IActionWrapper<IDeleteAction> deleteAction(String pathInfo);
	
	IActionWrapper<IPostAction> postAction(String pathInfo);
	
	IActionWrapper<IPutAction> putAction(String pathInfo);

}
