package com.googlecode.jpattern.rest.command;

import javax.servlet.http.HttpServletRequest;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.core.util.ValueUtil;
import com.googlecode.jpattern.rest.domain.URLPath;

/**
 * 
 * @author Francesco Cina'
 *
 * 12/mag/2011
 */
public class BuildURLCommand extends ACommand {

	private static final long serialVersionUID = 1L;
	private final HttpServletRequest request;
	private final URLPath urlPath;

	public BuildURLCommand(HttpServletRequest request, URLPath urlPath) {
		this(request, urlPath, new NullCommand());
	}
			
	public BuildURLCommand(HttpServletRequest request, URLPath urlPath, ICommand previousCommand) {
		super(previousCommand);
		this.request = request;
		this.urlPath = urlPath;
	}

	@Override
	protected void result(ICommandResult result) {
		urlPath.setScheme( ValueUtil.stringNotNull( request.getScheme() ,"" ) );
		urlPath.setServerName( ValueUtil.stringNotNull( request.getServerName() ,"" ) );
		urlPath.setServerPort( request.getServerPort() );
		urlPath.setContextPath( ValueUtil.stringNotNull( request.getContextPath() ,"" ) );
		urlPath.setServletPath( ValueUtil.stringNotNull( request.getServletPath() ,"" ) );
		urlPath.setPathInfo( ValueUtil.stringNotNull( request.getPathInfo() ,"" ) );
		urlPath.setQueryString( ValueUtil.stringNotNull( request.getQueryString() ,"" ) );
	}

	@Override
	protected void internalRollBack(ICommandResult result) {
	}

}
