package com.googlecode.jpattern.rest.command;

import org.codehaus.jackson.map.ObjectMapper;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.core.util.GenericWrapper;
import com.googlecode.jpattern.shared.result.ErrorMessage;

/**
 * 
 * @author Francesco Cina'
 *
 * 11/mag/2011
 */
public class JsonToObjectCommand<T> extends ACommand {

	private static final long serialVersionUID = 1L;
	private static ObjectMapper MAPPER = new ObjectMapper();
	private final Class<T> aClass;
	private final GenericWrapper<T> resultWrapper;
	private final StringBuffer jsonString;

	public JsonToObjectCommand(Class<T> aClass, GenericWrapper<T> resultWrapper, StringBuffer jsonString) {
		this(aClass, resultWrapper, jsonString, new NullCommand());
	}
	
	public JsonToObjectCommand(Class<T> aClass, GenericWrapper<T> resultWrapper, StringBuffer jsonString, ICommand previousCommand) {
		super(previousCommand);
		this.aClass = aClass;
		this.resultWrapper = resultWrapper;
		this.jsonString = jsonString;
	}

	@Override
	protected void result(ICommandResult result) {
		try {
			resultWrapper.setValue( MAPPER.readValue(jsonString.toString(), aClass) );			
		} catch (Exception e) {
			result.addErrorMessage(new ErrorMessage(getClass().getName(), e.getMessage()));
			getLogger().error("result", "", e);
		}
	}

	@Override
	protected void internalRollBack(ICommandResult result) {
	}

}
