package com.googlecode.jpattern.rest.command;

import java.io.OutputStream;

import org.codehaus.jackson.map.ObjectMapper;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.shared.result.ErrorMessage;

/**
 * 
 * @author Francesco Cina'
 *
 * 11/mag/2011
 */
public class ObjectToJsonStreamCommand extends ACommand {

	private static final long serialVersionUID = 1L;
	private static ObjectMapper MAPPER = new ObjectMapper();
	private final Object object;
	private final OutputStream outputStream;

	public ObjectToJsonStreamCommand(Object object, OutputStream outputStream) {
		this(object, outputStream, new NullCommand());
	}

	public ObjectToJsonStreamCommand(Object object, OutputStream outputStream, ICommand previousCommand) {
		super(previousCommand);
		this.object = object;
		this.outputStream = outputStream;
	}

	@Override
	protected void result(ICommandResult result) {
        try {
        	MAPPER.writeValue(outputStream, object);
		} catch (Exception e) {
			result.addErrorMessage(new ErrorMessage(getClass().getName(), e.getMessage()));
			getLogger().error("result", "", e);
		}
	}

	@Override
	protected void internalRollBack(ICommandResult result) {
	}

}
