package com.googlecode.jpattern.rest.command;

import java.io.StringWriter;

import org.codehaus.jackson.map.ObjectMapper;

import com.googlecode.jpattern.core.command.ACommand;
import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.core.command.ICommandResult;
import com.googlecode.jpattern.core.command.NullCommand;
import com.googlecode.jpattern.shared.result.ErrorMessage;

/**
 * 
 * @author Francesco Cina'
 *
 * 11/mag/2011
 */
public class ObjectToJsonStringCommand extends ACommand {

	private static final long serialVersionUID = 1L;
	private static ObjectMapper MAPPER = new ObjectMapper();
	private final Object object;
	private final StringBuffer outJsonString;

	public ObjectToJsonStringCommand(Object object, StringBuffer outJsonString) {
		this(object, outJsonString, new NullCommand());
	}
	
	public ObjectToJsonStringCommand(Object object, StringBuffer outJsonString, ICommand previousCommand) {
		super(previousCommand);
		this.object = object;
		this.outJsonString = outJsonString;
	}

	@Override
	protected void result(ICommandResult result) {
        try {
            StringWriter writer = new StringWriter();
			MAPPER.writeValue(writer, object);
			outJsonString.append(writer.toString());
		} catch (Exception e) {
			result.addErrorMessage(new ErrorMessage(getClass().getName(), e.getMessage()));
			getLogger().error("result", "", e);
		}
 		
	}

	@Override
	protected void internalRollBack(ICommandResult result) {
	}

}
