/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.BeanMappingExecutor;
import com.agapple.mapping.core.BeanMappingParam;
import com.agapple.mapping.core.builder.BeanMappingBuilder;
import com.agapple.mapping.core.config.BeanMappingConfigHelper;
import com.agapple.mapping.core.config.BeanMappingEnvironment;
import com.agapple.mapping.core.config.BeanMappingObject;
import com.agapple.mapping.core.helper.ContextObjectHolder;
import com.agapple.mapping.core.process.ValueProcess;
import com.agapple.mapping.process.script.ScriptHelper;
import java.util.List;

public class BeanMapping {
    private BeanMappingObject config;

    public BeanMapping(BeanMappingObject config) {
        this.config = config;
    }

    public BeanMapping(BeanMappingBuilder builder) {
        this.config = builder.get();
    }

    public static BeanMapping create(String mappingName) {
        BeanMappingObject config = BeanMappingConfigHelper.getInstance().getBeanMappingObject(mappingName);
        if (config == null) {
            throw new BeanMappingException("can not found mapping config for name[" + mappingName + "]");
        }
        return new BeanMapping(config);
    }

    public static BeanMapping create(Class srcClass, Class targetClass) {
        BeanMappingObject config = BeanMappingConfigHelper.getInstance().getBeanMappingObject(srcClass, targetClass);
        if (config == null) {
            throw new BeanMappingException("can not found mapping config for srcClass[" + srcClass.toString() + "] targetClass[" + targetClass + "]");
        }
        return new BeanMapping(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapping(Object src, Object target) throws BeanMappingException {
        boolean first = ContextObjectHolder.getInstance().enter();
        boolean isBeanMappingSupportScript = BeanMappingEnvironment.isBeanMappingSupportScript();
        BeanMappingParam param = new BeanMappingParam();
        param.setSrcRef(src);
        param.setTargetRef(target);
        param.setConfig(this.config);
        List<ValueProcess> vps = BeanMappingEnvironment.getBeanMappingVps();
        param.setProcesses(vps);
        try {
            BeanMappingExecutor.execute(param);
        }
        finally {
            if (first) {
                ContextObjectHolder.getInstance().clear();
                if (isBeanMappingSupportScript) {
                    ScriptHelper.getInstance().getScriptExecutor().disposeFunctions();
                }
            }
        }
    }
}

