/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.config;

import com.agapple.mapping.core.builder.BeanMappingBuilder;
import com.agapple.mapping.core.config.BeanMappingBehavior;
import com.agapple.mapping.core.config.BeanMappingConfigRespository;
import com.agapple.mapping.core.config.BeanMappingObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class BeanMappingConfigHelper {
    private static volatile BeanMappingConfigHelper singleton = null;
    private BeanMappingConfigRespository repository = null;
    private BeanMappingConfigRespository autoRepository = null;
    private volatile BeanMappingBehavior globalBehavior = null;

    public BeanMappingConfigHelper() {
        this.repository = new BeanMappingConfigRespository();
        this.autoRepository = new BeanMappingConfigRespository();
        this.globalBehavior = new BeanMappingBehavior();
    }

    public BeanMappingConfigHelper(BeanMappingConfigRespository repository) {
        this.repository = repository;
        this.autoRepository = new BeanMappingConfigRespository();
        this.globalBehavior = new BeanMappingBehavior();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BeanMappingConfigHelper getInstance() {
        if (singleton != null) return singleton;
        Class<BeanMappingConfigHelper> clazz = BeanMappingConfigHelper.class;
        synchronized (BeanMappingConfigHelper.class) {
            if (singleton != null) return singleton;
            singleton = new BeanMappingConfigHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public BeanMappingObject getBeanMappingObject(Class src, Class target) {
        return this.getFromRepository(src, target, this.repository);
    }

    public BeanMappingObject getBeanMappingObject(String name) {
        return this.repository.getBeanMappingObject(name);
    }

    public BeanMappingObject getBeanMappingObject(Class src, Class target, boolean autoRegister) {
        BeanMappingObject object = this.autoRepository.getBeanMappingObject(src, target);
        if (object == null && autoRegister) {
            this.autoRepository.register(src, target);
            object = this.getFromRepository(src, target, this.autoRepository);
        }
        return object;
    }

    public BeanMappingObject getBeanMapObject(Class src, Class target, boolean autoRegister) {
        BeanMappingObject object = this.autoRepository.getBeanMappingObject(src, target);
        if (object == null && autoRegister) {
            if (this.isMap(src)) {
                this.autoRepository.registerMap(target);
            } else {
                this.autoRepository.registerMap(src);
            }
            object = this.getFromRepository(src, target, this.autoRepository);
        }
        return object;
    }

    public void register(BeanMappingObject object) {
        this.repository.register(object);
    }

    public void register(BeanMappingBuilder builder) {
        this.repository.register(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfig(String file) {
        InputStream in = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = BeanMappingConfigRespository.class.getClassLoader();
        }
        in = cl.getResourceAsStream(file);
        try {
            this.repository.registerConfig(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void registerConfig(InputStream in) {
        this.repository.registerConfig(in);
    }

    private BeanMappingObject getFromRepository(Class src, Class target, BeanMappingConfigRespository repository) {
        BeanMappingObject object = repository.getBeanMappingObject(src, target);
        if (object == null) {
            boolean isSrcMap = this.isMap(src);
            boolean isTargetMap = this.isMap(target);
            if (isSrcMap && isTargetMap) {
                object = repository.getBeanMappingObject(Map.class, Map.class);
            } else if (isSrcMap) {
                object = repository.getBeanMappingObject(Map.class, target);
            } else if (this.isMap(target)) {
                object = repository.getBeanMappingObject(src, Map.class);
            }
        }
        return object;
    }

    private boolean isMap(Class clazz) {
        return clazz != null && Map.class.isAssignableFrom(clazz);
    }

    public void setRepository(BeanMappingConfigRespository repository) {
        this.repository = repository;
    }

    public BeanMappingBehavior getGlobalBehavior() {
        return this.globalBehavior;
    }

    public void setGlobalBehavior(BeanMappingBehavior globalBehavior) {
        this.globalBehavior = globalBehavior;
    }
}

