/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.config;

import com.agapple.mapping.core.builder.BeanMappingBuilder;
import com.agapple.mapping.core.config.BeanMappingObject;
import com.agapple.mapping.core.config.parse.BeanMappingParser;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanMappingConfigRespository {
    private static final Logger logger = LoggerFactory.getLogger(BeanMappingConfigRespository.class);
    private static final String SEPERATOR = ":";
    private Map<String, BeanMappingObject> mappings = new ConcurrentHashMap<String, BeanMappingObject>(10);

    public BeanMappingObject getBeanMappingObject(Class src, Class target) {
        return this.mappings.get(this.mapperObjectName(src, target));
    }

    public BeanMappingObject getBeanMappingObject(String name) {
        return this.mappings.get(name);
    }

    public void register(BeanMappingBuilder builder) {
        if (builder != null) {
            BeanMappingObject object = builder.get();
            this.register(object);
        }
    }

    public void register(BeanMappingObject object) {
        BeanMappingObject old = null;
        String name = null;
        if (object != null) {
            name = StringUtils.isEmpty((String)object.getName()) ? this.mapperObjectName(object.getSrcClass(), object.getTargetClass()) : object.getName();
            old = this.mappings.put(name, object);
        }
        if (old != null) {
            logger.warn("{} has been replaced by : {}", (Object)name, (Object)object.toString());
        }
    }

    public void register(Class src, Class target) {
        List<BeanMappingObject> objects = BeanMappingParser.parseMapping(src, target);
        for (BeanMappingObject object : objects) {
            this.register(object);
        }
    }

    public void registerMap(Class src) {
        List<BeanMappingObject> objects = BeanMappingParser.parseMapMapping(src);
        for (BeanMappingObject object : objects) {
            this.register(object);
        }
    }

    public void registerConfig(InputStream in) {
        List<BeanMappingObject> objects = BeanMappingParser.parseMapping(in);
        for (BeanMappingObject object : objects) {
            this.register(object);
        }
    }

    private String mapperObjectName(Class src, Class dest) {
        String name1 = src.getName();
        String name2 = dest.getName();
        return name1 + SEPERATOR + name2;
    }
}

