/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.config.parse;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.helper.ReflectionHelper;
import com.agapple.mapping.process.convertor.Convertor;
import com.agapple.mapping.process.convertor.ConvertorHelper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConvertorParse {
    private static final Logger logger = LoggerFactory.getLogger(ConvertorParse.class);

    public static void parseAndRegister(Node convertorsNode) {
        NodeList nodeList = convertorsNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"convertor".equals(node.getNodeName())) continue;
            Node aliasNode = node.getAttributes().getNamedItem("alias");
            Node clazzNode = node.getAttributes().getNamedItem("class");
            Node srcClassNode = node.getAttributes().getNamedItem("srcClass");
            Node targetClassNode = node.getAttributes().getNamedItem("targetClass");
            if (clazzNode == null) continue;
            Class clazz = ReflectionHelper.forName(clazzNode.getNodeValue());
            if (!Convertor.class.isAssignableFrom(clazz)) {
                throw new BeanMappingException(clazz.toString() + " is not implements Convertor");
            }
            Convertor convertor = (Convertor)ReflectionHelper.newInstance(clazz);
            if (aliasNode != null) {
                String alias = aliasNode.getNodeValue();
                ConvertorHelper.getInstance().registerConvertor(alias, convertor);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("register Convertor[" + clazz.toString() + "] to alias[" + alias + "]");
                continue;
            }
            String srcClass = srcClassNode.getNodeValue();
            String targetClass = targetClassNode.getNodeValue();
            if (StringUtils.isEmpty((String)srcClass) || StringUtils.isEmpty((String)targetClass)) {
                throw new BeanMappingException(clazz.toString() + " should fix srcClass and targetClass!");
            }
            Class srcClazz = ReflectionHelper.forName(srcClassNode.getNodeValue());
            Class targetClazz = ReflectionHelper.forName(targetClassNode.getNodeValue());
            ConvertorHelper.getInstance().registerConvertor(srcClazz, targetClazz, convertor);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("register Convertor[" + clazz.toString() + "] used by srcClass[" + srcClass.toString() + "]" + " targetClass[" + targetClass.toString() + "]");
        }
    }
}

