/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.core.helper;

import java.util.HashMap;
import java.util.Map;

public class ContextObjectHolder {
    private static volatile ContextObjectHolder singleton = null;
    public static final String MAPPING_ENTER = "_mapping_enter_";
    public static final String SCRIPT_CONTEXT = "_script_context_";
    public static final String PROCESS_CONTEXT = "_process_context_";
    private ThreadLocal<Map<Object, Object>> context = new ThreadLocal<Map<Object, Object>>(){

        @Override
        protected Map<Object, Object> initialValue() {
            return new HashMap<Object, Object>(10);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContextObjectHolder getInstance() {
        if (singleton != null) return singleton;
        Class<ContextObjectHolder> clazz = ContextObjectHolder.class;
        synchronized (ContextObjectHolder.class) {
            if (singleton != null) return singleton;
            singleton = new ContextObjectHolder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public boolean enter() {
        Map<Object, Object> map = this.context.get();
        Object value = map.put(MAPPING_ENTER, true);
        return value == null;
    }

    public void clear() {
        this.context.get().clear();
    }

    public void put(Object key, Object value) {
        this.context.get().put(key, value);
    }

    public Object get(Object key) {
        return this.context.get().get(key);
    }

    public Object remove(Object key) {
        return this.context.get().remove(key);
    }
}

