/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process;

import com.agapple.mapping.core.BeanMappingException;
import com.agapple.mapping.core.config.BeanMappingField;
import com.agapple.mapping.core.process.ValueProcess;
import com.agapple.mapping.core.process.ValueProcessInvocation;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugValueProcess
implements ValueProcess {
    private static final Logger logger = LoggerFactory.getLogger(DebugValueProcess.class);

    @Override
    public Object process(Object value, ValueProcessInvocation invocation) throws BeanMappingException {
        BeanMappingField currentField = invocation.getContext().getCurrentField();
        if (!currentField.isMapping() && invocation.getContext().getBeanObject().getBehavior().isDebug() && logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("srcName[" + currentField.getSrcField().getName());
            builder.append("],srcClass[" + ObjectUtils.toString((Object)currentField.getSrcField().getClazz(), (String)"null"));
            builder.append("],targetName[" + currentField.getTargetField().getName());
            builder.append("],targetClass[" + ObjectUtils.toString((Object)currentField.getTargetField().getClazz(), (String)"null"));
            if (StringUtils.isNotEmpty((String)currentField.getDefaultValue())) {
                builder.append("],[defaultValue=" + currentField.getDefaultValue());
            }
            if (StringUtils.isNotEmpty((String)currentField.getConvertor())) {
                builder.append("],[convertor=" + currentField.getConvertor());
            }
            if (StringUtils.isNotEmpty((String)currentField.getScript())) {
                builder.append("],[script=" + currentField.getScript());
            }
            builder.append("], Value = " + ObjectUtils.toString((Object)value, (String)"null"));
            logger.debug(builder.toString());
        }
        return invocation.proceed(value);
    }
}

