/*
 * Decompiled with CFR 0.152.
 */
package com.agapple.mapping.process.script.jexl;

import com.agapple.mapping.process.script.ScriptContext;
import com.agapple.mapping.process.script.ScriptExecutor;
import com.agapple.mapping.process.script.jexl.JexlScriptContext;
import com.agapple.mapping.process.script.jexl.ScriptJexlEngine;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;

public class JexlScriptExecutor
implements ScriptExecutor {
    private static final int DEFAULT_CACHE_SIZE = 1000;
    private ScriptJexlEngine engine;
    private Map<String, Object> functions;
    private int cacheSize = 1000;

    public JexlScriptExecutor() {
        this.initialize();
    }

    public void initialize() {
        if (this.cacheSize <= 0) {
            this.cacheSize = 1000;
        }
        this.functions = new HashMap<String, Object>();
        this.engine = new ScriptJexlEngine();
        this.engine.setCache(this.cacheSize);
        this.engine.setSilent(true);
        this.engine.setFunctions(this.functions);
    }

    @Override
    public ScriptContext genScriptContext(Map<String, Object> context) {
        return new JexlScriptContext(context);
    }

    @Override
    public Object evaluate(Map<String, Object> context, String script) {
        return this.evaluate(this.genScriptContext(context), script);
    }

    @Override
    public Object evaluate(ScriptContext context, String script) {
        Expression expr = this.engine.createExpression(script);
        return expr.evaluate((JexlContext)context);
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Override
    public void addFunction(String name, Object obj) {
        this.functions.put(name, obj);
    }

    @Override
    public void disposeFunctions() {
        this.engine.disposeUsedFunctions();
    }
}

